/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.base.logon.Logon;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.task.LauncherTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.ProgressActionHandler;
import com.ibm.hwmca.fw.task.ProgressBean;
import com.ibm.hwmca.fw.task.ProgressChangeEvent;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndEvent;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressListener;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.task.ProgressTimerTask;
import com.ibm.hwmca.fw.task.ProgressUpdateEvent;
import com.ibm.hwmca.fw.task.TaskLauncher;
import com.ibm.hwmca.fw.tasklet.PanelTask;
import com.ibm.hwmca.fw.tasklet.xport.AbnormalTaskletTerminationWithDetailsException;
import com.ibm.hwmca.fw.util.HMCUserTaskManager;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.UserTaskManager;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public abstract class PresentationTask
implements ProgressListener {
    private static final String TRACE_MASKT = "XFRMPTIT";
    private static final String TRACE_MASKF = "XFRMPTIF";
    private static final String TRACE_MASKD = "XFRMPTID";
    private static final String highlightTextSwing = "<html><body bgcolor=\"RED\"><font color=\"BLACK\">{0}</font></body></html>";
    private static final String highlightTextHtml = "<font color=\"RED\">{0}</font>";
    private static final String regularTextSwing = "<html>{0}</html>";
    private static final String regularTextHtml = "{0}";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "PresentTask");
    protected PresentationTaskParms parms;
    private long taskId = 0L;
    private PanelModelTaskPortal panelModelTaskPortal;
    private boolean forcedToTerminate;
    private HashMap windows;
    private static Timer timer = new Timer(true);
    private Object returnValue;
    private boolean taskHasEnded;
    private Date startTime;
    private String highlightText = "{0}";
    private String regularText = "{0}";

    public PresentationTask(PresentationTaskParms parms) throws IllegalArgumentException {
        if (parms == null) {
            throw new IllegalArgumentException("null parms specified");
        }
        this.parms = parms;
        this.windows = new HashMap();
        this.startTime = new Date();
        if (CommonSystem.getCommonSystem().isUsingHTML()) {
            this.highlightText = highlightTextHtml;
            this.regularText = regularTextHtml;
        } else {
            this.highlightText = highlightTextSwing;
            this.regularText = regularTextSwing;
        }
        Trace.trace(TRACE_MASKT, "<> PresentationTask.ctor()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initTask(TaskLauncher launcher) throws HException {
        try {
            block15: {
                try {
                    if (this instanceof PanelTask) {
                        Trace.trace(TRACE_MASKF, "-> PresentationTask.initTask() for PanelTask instance");
                        if (this.parms.getTaskId() != null) {
                            ((PanelTask)this).addListener(launcher);
                            String realTasklet = ((PanelTask)this).getInitiatingTaskletName();
                            ((PanelTask)this).setInitiatingTaskletName(LauncherTask.LAUNCHER_TASKLET);
                            ((PanelTask)this).setInitialData("REAL_TASKLET", realTasklet);
                        }
                        if (CommonSystem.getCommonSystem().isUsingHTML()) {
                            ((PanelTask)this).setClientUserContext(this.getHMCSession().getUserContext());
                        } else {
                            ClientUserContext userContext = launcher.getUserContext();
                            if (userContext != null) {
                                ((PanelTask)this).setClientUserContext(userContext);
                            } else {
                                ((PanelTask)this).setClientUserContext(Logon.getLogon().getClientUserContext());
                            }
                        }
                        this.returnValue = this.runTask();
                        ((PanelTask)this).removeListener(launcher);
                        launcher.response((PanelTask)this, null);
                        break block15;
                    }
                    if (this.parms != null && this.parms.getTaskId() != null) {
                        Trace.trace(TRACE_MASKF, "-> PresentationTask.initTask() for non-PanelTask instance");
                        LauncherTask checker = new LauncherTask(this.parms, this.getTaskId());
                        checker.addListener(launcher);
                        boolean keepGoing = checker.execute();
                        checker.removeListener(launcher);
                        launcher.response(checker, null);
                        if (keepGoing) {
                            this.parms = checker.getParms();
                            this.returnValue = this.runTask();
                        }
                        break block15;
                    }
                    launcher.response(null, null);
                    this.returnValue = this.runTask();
                }
                catch (Throwable e) {
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    Trace.trace(TRACE_MASKT, "Task ended due to uncaught exception:");
                    Trace.trace(TRACE_MASKT, e);
                    if (!this.forcedToTerminate) {
                        this.logException(e);
                        TaskLauncher.displayInternalErrorMessage(e);
                        HException hex = new HException(e);
                        if (e instanceof AbnormalTaskletTerminationWithDetailsException) {
                            hex.add(((AbnormalTaskletTerminationWithDetailsException)e).getDetails());
                        }
                        throw hex;
                    }
                    Object var5_8 = null;
                    this.indicateTaskHasEnded();
                }
            }
            Object var5_7 = null;
            this.indicateTaskHasEnded();
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.indicateTaskHasEnded();
            throw throwable;
        }
    }

    private synchronized void indicateTaskHasEnded() {
        this.taskHasEnded = true;
        this.notifyAll();
    }

    public synchronized boolean isTaskEnded() {
        return this.taskHasEnded;
    }

    public synchronized Object waitForTaskToEnd() throws InterruptedException {
        Trace.trace(TRACE_MASKT, "Waiting for task with id==" + this.taskId + " to end.");
        while (!this.taskHasEnded) {
            this.wait();
        }
        Trace.trace(TRACE_MASKT, "Done waiting for task with id==" + this.taskId + " to end.");
        return this.returnValue;
    }

    public PresentationTaskParms getParms() {
        return this.parms;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    void setHMCSession(HMCSession hmcSession) {
        if (hmcSession == null) {
            throw new NullPointerException("HMCSession must be non-null");
        }
        if (this.panelModelTaskPortal != null) {
            throw new IllegalStateException("HMCSession is already set");
        }
        this.panelModelTaskPortal = new PanelModelTaskPortal(this, hmcSession);
    }

    public PanelModelTaskPortal getPanelModelTaskPortal() {
        return this.panelModelTaskPortal;
    }

    public HMCSession getHMCSession() {
        if (this.panelModelTaskPortal == null) {
            return null;
        }
        return this.panelModelTaskPortal.getHMCSession();
    }

    public void forceTaskToTerminate(String reason) {
        this.forcedToTerminate = true;
        try {
            if (this.panelModelTaskPortal != null) {
                this.panelModelTaskPortal.terminateTask();
            }
        }
        catch (Throwable e) {
            if (e instanceof ThreadDeath) {
                throw (ThreadDeath)e;
            }
            Trace.trace(TRACE_MASKD, "Received exception calling PanelModelTaskPortal.terminateTask() trying to force a task to terminate:");
            Trace.trace(TRACE_MASKD, e);
        }
        try {
            this.forceTermination(reason);
        }
        catch (Throwable e) {
            if (e instanceof ThreadDeath) {
                throw (ThreadDeath)e;
            }
            Trace.trace(TRACE_MASKD, "Received exception calling PresentationTask.forceTermination() trying to force a task to terminate:");
            Trace.trace(TRACE_MASKD, e);
        }
    }

    public boolean wasTaskForcedToTerminate() {
        return this.forcedToTerminate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeProgress(ProgressChangeEvent evt) {
        Trace.trace(TRACE_MASKT, "-> PresentationTask.changeProgress()");
        ProgressTimerTask timerTask = null;
        HashMap hashMap = this.windows;
        synchronized (hashMap) {
            timerTask = (ProgressTimerTask)this.windows.get(evt.getId());
            if (timerTask == null) {
                throw new IllegalArgumentException("Progress ID does not exist.");
            }
        }
        UserTaskManager utm = timerTask.getUserTaskManager();
        ProgressBean bean = (ProgressBean)utm.getDataObjects()[0];
        ProgressStartEvent start = bean.getStartEvent();
        switch (evt.getChangeType()) {
            case 3: {
                start.setProgressCancelListener(evt.getProgressCancelListener());
                if (bean.isCanceled()) {
                    utm.setEnabled("CancelTaskButton", false);
                } else if (evt.getProgressCancelListener() != null) {
                    utm.setEnabled("CancelTaskButton", true);
                } else {
                    utm.setEnabled("CancelTaskButton", false);
                }
                utm.refreshElement("CancelTaskButton");
                break;
            }
            case 4: {
                start.setProgressEndedListener(evt.getProgressEndedListener());
                break;
            }
            case 1: 
            case 2: {
                int[] selRows;
                ProgressData[] oldStartData = start.getProgressData();
                boolean addRemove = evt.getChangeType() == 1;
                boolean changed = start.changeProgressData(evt.getProgressData(), addRemove);
                if (!changed) break;
                ProgressData[] data = start.getProgressData();
                ItemDescriptor[] newname = new ItemDescriptor[data.length];
                ItemDescriptor[] newdesc = new ItemDescriptor[data.length];
                ItemDescriptor[] name = bean.getObjectNamePColList();
                ItemDescriptor[] desc = bean.getObjectStatusColList();
                int[] newSelRows = selRows = utm.getSelectedRows("TargetProgressTable");
                if (!addRemove && selRows != null && selRows.length > 0 && selRows[0] >= 0 && selRows[0] < oldStartData.length) {
                    boolean stillPresent = false;
                    ObjectId selId = oldStartData[selRows[0]].getObjectId();
                    int i = 0;
                    while (i < data.length && !stillPresent) {
                        if (data[i] != null && data[i].getObjectId().equals(selId)) {
                            stillPresent = true;
                        }
                        ++i;
                    }
                    if (!stillPresent) {
                        newSelRows = new int[]{};
                    }
                }
                int i = 0;
                while (i < data.length) {
                    Object[] subst;
                    if (data[i].getCompletionStatus() != 2 && data[i].getCompletionStatus() != 3) {
                        subst = new Object[]{data[i].getText().toString()};
                        newdesc[i] = new ItemDescriptor("Status_" + String.valueOf(i), MessageFormat.format(this.regularText, subst));
                        newname[i] = new ItemDescriptor("Object_" + String.valueOf(i), data[i].getName().toString().replace('\n', ':'));
                    } else {
                        subst = new Object[]{data[i].getText().toString()};
                        newdesc[i] = new ItemDescriptor("Status_" + String.valueOf(i), MessageFormat.format(this.highlightText, subst));
                        subst[0] = data[i].getName().toString().replace('\n', ':');
                        newname[i] = new ItemDescriptor("Object_" + String.valueOf(i), MessageFormat.format(this.highlightText, subst));
                    }
                    ++i;
                }
                bean.setObjectNamePColList(newname);
                bean.setObjectStatusColList(newdesc);
                int j = 0;
                while (j < 2) {
                    utm.refreshElement("ObjectNamePCol");
                    utm.refreshElement("ObjectStatusCol");
                    utm.setSelectedRows("TargetProgressTable", newSelRows);
                    ++j;
                }
                break;
            }
        }
        Trace.trace(TRACE_MASKT, "<- PresentationTask.changeProgress()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProgress(ProgressStartEvent evt) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> PresentationTask.startProgress()");
        HashMap hashMap = this.windows;
        synchronized (hashMap) {
            if (this.windows.get(evt.getId()) != null) {
                throw new IllegalArgumentException("Progress ID already exists.");
            }
        }
        HMCUserTaskManager utm = null;
        String panelName = "";
        try {
            ProgressBean bean = new ProgressBean();
            Object[] beans = new ProgressBean[]{bean};
            bean.setStartEvent(evt);
            bean.load();
            ProgressData[] data = evt.getProgressData();
            String packageName = "com.ibm.hwmca.fw.task.res.ProgressRes";
            Trace.trace(TRACE_MASKF, "Package Name=" + packageName);
            Trace.trace(TRACE_MASKF, "Panel Name=" + panelName);
            String format = regularTextHtml;
            if (data.length == 1 && data[0].getObjectId() == null) {
                panelName = "NonTargetedProgressPanel";
                format = new LocalizableText(packageName, "NonTargetedProgressPanel.TEXT").toString();
            } else {
                panelName = "TargetProgressPanel";
                format = new LocalizableText(packageName, "TargetProgressPanel.TEXT").toString();
            }
            Properties utmProp = null;
            if (evt.getHelpInfo() != null) {
                utmProp = new Properties();
                utmProp.put("@" + panelName, evt.getHelpInfo());
            }
            utm = new HMCUserTaskManager(packageName, utmProp, panelName, beans, null, null);
            utm.setEnabled("OKButton", false);
            if (evt.isCancelSupported()) {
                utm.setEnabled("CancelTaskButton", true);
            }
            utm.setShown("DurationTimeOutput", bean.getDuration() != 0L);
            Object[] subst = new Object[]{evt.getTaskName().toString().replace('\n', ' ')};
            utm.setCaptionText(panelName, MessageFormat.format(format, subst));
            utm.addCancelListener(new ProgressActionHandler());
            utm.invoke();
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "AUIML exception: name=[com.ibm.hwmca.fw.task.res.ProgressRes]panel name=[" + panelName + "]" + "bean class name= [com.ibm.hwmca.fw.task.ProgressBean");
            Trace.trace(TRACE_MASKF, exc);
        }
        HashMap hashMap2 = this.windows;
        synchronized (hashMap2) {
            ProgressTimerTask timerTask = new ProgressTimerTask(utm);
            timer.scheduleAtFixedRate((TimerTask)timerTask, 1000L, 1000L);
            this.windows.put(evt.getId(), timerTask);
            Trace.trace(TRACE_MASKF, "Starting elapsed timer task for ID=" + evt.getId() + ".");
        }
        Trace.trace(TRACE_MASKT, "<- PresentationTask.startProgress()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endProgress(ProgressEndEvent evt) {
        Trace.trace(TRACE_MASKT, "-> PresentationTask.endProgress()");
        HashMap hashMap = this.windows;
        synchronized (hashMap) {
            ProgressTimerTask timerTask = (ProgressTimerTask)this.windows.get(evt.getId());
            if (timerTask != null) {
                UserTaskManager utm = timerTask.getUserTaskManager();
                utm.setEnabled("OKButton", true);
                utm.setEnabled("CancelTaskButton", false);
                utm.refreshAllElements();
                ProgressBean bean = (ProgressBean)utm.getDataObjects()[0];
                bean.setEnded(true);
                this.windows.remove(evt.getId());
                timerTask.cancel();
                if (evt.getAutoDismissal() == 0) {
                    ProgressStartEvent start = bean.getStartEvent();
                    ProgressEndedListener callback = start.getProgressEndedListener();
                    if (callback != null) {
                        ProgressActionHandler.callListener(null, callback, start.getId());
                    } else {
                        Trace.trace(TRACE_MASKF, "progressEnded callback is null, so no one is being notified");
                    }
                    utm.dispose();
                } else if (evt.getAutoDismissal() > 0) {
                    ProgressTimerTask newTimerTask = new ProgressTimerTask(utm);
                    newTimerTask.setMode(true);
                    timer.schedule((TimerTask)newTimerTask, evt.getAutoDismissal() * 1000);
                }
            } else {
                throw new IllegalArgumentException("Progress ID does not exist.");
            }
            Trace.trace(TRACE_MASKF, "Stopping elapsed timer task for ID=" + evt.getId() + ".");
        }
        Trace.trace(TRACE_MASKT, "<- PresentationTask.endProgress()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgress(ProgressUpdateEvent evt) {
        Trace.trace(TRACE_MASKT, "-> PresentationTask.updateProgress()");
        ProgressData data = evt.getProgressData();
        if (data != null) {
            ProgressTimerTask timerTask = null;
            HashMap hashMap = this.windows;
            synchronized (hashMap) {
                timerTask = (ProgressTimerTask)this.windows.get(evt.getId());
                if (timerTask == null) {
                    throw new IllegalArgumentException("Progress ID does not exist.");
                }
            }
            UserTaskManager utm = timerTask.getUserTaskManager();
            ProgressBean bean = (ProgressBean)utm.getDataObjects()[0];
            ProgressStartEvent start = bean.getStartEvent();
            ProgressData[] startData = start.getProgressData();
            boolean bDone = false;
            int i = 0;
            while (i < startData.length && !bDone) {
                if (data.getObjectId() == null && startData[i].getObjectId() == null) {
                    bDone = true;
                } else if (data.getObjectId() != null && startData[i].getObjectId() != null && data.getObjectId().equals(startData[i].getObjectId())) {
                    bDone = true;
                }
                if (bDone) {
                    Trace.trace(TRACE_MASKF, "we found a matching entry");
                    if (data.getCompletionStatus() != -1) {
                        startData[i].setCompletionStatus(data.getCompletionStatus());
                    }
                    if (data.getDurationTime() != 0L) {
                        Trace.trace(TRACE_MASKF, "we got an update for the duration time");
                        startData[i].setDurationTime(data.getDurationTime());
                        bean.setDuration();
                        utm.refreshElement("DurationTimeOutput");
                    }
                    if (data.getText() != null) {
                        Trace.trace(TRACE_MASKF, "we got an update for the text");
                        startData[i].setText(data.getText());
                        if (startData[i].getObjectId() == null) {
                            Object[] subst;
                            if (startData[i].getCompletionStatus() != 2 && startData[i].getCompletionStatus() != 3) {
                                subst = new Object[]{data.getText().toString()};
                                bean.setProgressMessageOutput(MessageFormat.format(this.regularText, subst));
                            } else {
                                subst = new Object[]{data.getText().toString()};
                                bean.setProgressMessageOutput(MessageFormat.format(this.highlightText, subst));
                            }
                            utm.refreshAllElements();
                        } else {
                            Object[] subst;
                            ItemDescriptor[] name = bean.getObjectNamePColList();
                            ItemDescriptor[] desc = bean.getObjectStatusColList();
                            int[] selRows = utm.getSelectedRows("TargetProgressTable");
                            Trace.trace(TRACE_MASKF, "we think [" + selRows.length + "] items are selected");
                            if (selRows.length > 0) {
                                Trace.trace(TRACE_MASKF, "we think item [" + selRows[0] + "] is selected");
                            }
                            Trace.trace(TRACE_MASKF, "updating name: " + name[i].getName() + " title: " + name[i].getTitle() + " item #" + i);
                            if (startData[i].getCompletionStatus() != 2 && startData[i].getCompletionStatus() != 3) {
                                subst = new Object[]{data.getText().toString()};
                                desc[i] = new ItemDescriptor(desc[i].getName(), MessageFormat.format(this.regularText, subst));
                                name[i] = new ItemDescriptor(name[i].getName(), name[i].getTitle());
                            } else {
                                subst = new Object[]{data.getText().toString()};
                                desc[i] = new ItemDescriptor(desc[i].getName(), MessageFormat.format(this.highlightText, subst));
                                subst[0] = name[i].getTitle();
                                name[i] = new ItemDescriptor(name[i].getName(), MessageFormat.format(this.highlightText, subst));
                            }
                            bean.setObjectNamePColList(name);
                            bean.setObjectStatusColList(desc);
                            int j = 0;
                            while (j < 2) {
                                utm.refreshElement("ObjectNamePCol");
                                utm.refreshElement("ObjectStatusCol");
                                utm.setSelectedRows("TargetProgressTable", selRows);
                                ++j;
                            }
                        }
                    }
                    if (data.getDetails() != null) {
                        startData[i].setDetails(data.getDetails());
                    }
                }
                ++i;
            }
            boolean what = false;
            int i2 = 0;
            while (i2 < startData.length && !what) {
                what = startData[i2].getDetails() != null;
                ++i2;
            }
            utm.setEnabled("DetailsButton", what);
        }
        Trace.trace(TRACE_MASKT, "<- PresentationTask.updateProgress()");
    }

    protected abstract Object runTask() throws Exception;

    public abstract void logException(Throwable var1);

    protected abstract void forceTermination(String var1);
}

